/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2678;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_4587;
import net.minecraft.class_5218;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import net.minecraft.class_6606;
import net.minecraft.class_742;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.interfaces.pushbox.IBossHealthPushBox;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.misc.Misc;
import xaero.common.mixin.MixinChunkDeltaUpdateS2CPacketAccessor;
import xaero.common.patreon.Patreon;

public class XaeroMinimapCore {
    public static AXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;
    private static boolean renderingWorld;
    private static class_1159 waypointsProjection;
    private static class_1159 waypointModelView;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = class_2818.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        class_2818 chunk = world.method_8497(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(int x, int z, class_6603 packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(x, z);
    }

    public static void onChunkLightData(int x, int z, class_6606 packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(x, z);
    }

    public static void onBlockChange(class_2626 packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.method_11309().method_10263() >> 4, packetIn.method_11309().method_10260() >> 4);
    }

    public static void onMultiBlockChange(class_2637 packetIn) {
        MixinChunkDeltaUpdateS2CPacketAccessor packetAccess = (MixinChunkDeltaUpdateS2CPacketAccessor)packetIn;
        XaeroMinimapCore.chunkUpdateCallback(packetAccess.getSectionPos().method_10263(), packetAccess.getSectionPos().method_10260());
    }

    public static class_2960 getPlayerCape(class_742 player) {
        return Patreon.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isWearing(class_1657 player, class_1664 part) {
        if (part != class_1664.field_7559 || !(player instanceof class_742)) {
            return null;
        }
        return Patreon.isWearingCape(modMain.getFileLayoutID(), (class_742)player);
    }

    public static void onPlayNetHandler(class_634 netHandler, class_2678 packet) {
        AXaeroMinimap.INSTANCE.tryLoadLater();
        if (modMain.getInterfaces().getMinimapInterface().getCrashedWith() != null) {
            return;
        }
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                MinimapLogs.LOGGER.info("Previous minimap session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init();
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            MinimapLogs.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(class_634 netHandler) {
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(class_1657 player) {
        if (player == class_310.method_1551().field_1724) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().createDeathpoint(player);
        }
    }

    public static void beforeRenderWorld() {
        renderingWorld = true;
    }

    public static void onResetProjectionMatrix(class_1159 matrixIn) {
        if (renderingWorld) {
            waypointsProjection.method_22668();
            waypointsProjection.method_22672(matrixIn);
            renderingWorld = false;
        }
    }

    public static void onWorldModelViewMatrix(class_4587 matrixStack) {
        waypointModelView.method_22668();
        waypointModelView.method_22672(matrixStack.method_23760().method_23761());
    }

    public static void beforeIngameGuiRender(float partialTicks) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            class_1041 mainwindow = class_310.method_1551().method_22683();
            class_1159 projectionMatrixBU = RenderSystem.getProjectionMatrix();
            class_1159 ortho = class_1159.method_34239((float)0.0f, (float)mainwindow.method_4489(), (float)0.0f, (float)mainwindow.method_4506(), (float)1000.0f, (float)3000.0f);
            RenderSystem.setProjectionMatrix((class_1159)ortho);
            RenderSystem.getModelViewStack().method_22903();
            RenderSystem.getModelViewStack().method_34426();
            RenderSystem.applyModelViewMatrix();
            modMain.getInterfaces().getMinimapInterface().getWaypointsIngameRenderer().render(minimapSession, partialTicks, minimapSession.getMinimapProcessor(), waypointsProjection, waypointModelView);
            RenderSystem.getModelViewStack().method_22909();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setProjectionMatrix((class_1159)projectionMatrixBU);
        }
    }

    public static void onPotionEffectsRender() {
        IPotionEffectsPushBox potionEffectsPushBox = modMain.getInterfaces().getPotionEffectPushBox();
        if (potionEffectsPushBox != null) {
            potionEffectsPushBox.setActive(true);
        }
    }

    public static void onBossHealthRender(int h) {
        IBossHealthPushBox bossHealthPushBox = modMain.getInterfaces().getBossHealthPushBox();
        if (bossHealthPushBox != null) {
            bossHealthPushBox.setActive(true);
            bossHealthPushBox.setLastBossHealthHeight(h);
        }
    }

    public static void onEntityIconsModelRenderDetection(class_583<?> model, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelRenderDetection(model, red, green, blue, alpha);
    }

    public static void onEntityIconsModelPartRenderDetection(class_630 modelRenderer, float red, float green, float blue, float alpha) {
        if (!EntityIconPrerenderer.DETECTING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconsModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    public static void onDeleteWorld(class_32.class_5143 levelStorageAccess) {
        Path worldMinimapDataFolder;
        Path worldName = levelStorageAccess.method_27010(class_5218.field_24188).getParent().getFileName();
        if (!worldName.toString().isEmpty() && (worldMinimapDataFolder = AXaeroMinimap.INSTANCE.getWaypointsFolder().toPath().resolve(worldName)).toFile().exists()) {
            try {
                Misc.deleteFile(worldMinimapDataFolder, 20);
                MinimapLogs.LOGGER.info(String.format("Deleted minimap world data at %s", worldMinimapDataFolder));
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error(String.format("Failed to delete minimap world data at %s!", worldMinimapDataFolder), (Throwable)e);
            }
        }
    }

    static {
        chunkCleanField = null;
        renderingWorld = false;
        waypointsProjection = new class_1159();
        waypointModelView = new class_1159();
    }
}

